import { range, some, sortBy } from 'lodash';
import {
  SeriesModel,
  EventModel,
  TournamentModel,
  TeamModel,
} from 'tourney-sdk-react';

import { SocialLink, TOURNAMENT_NAMES } from '../constants';

export function addCommasToNumber(num: number, minimumFractionDigits = 0) {
  return num.toLocaleString(
    undefined, // use a string like 'en-US' to override browser locale
    { minimumFractionDigits }
  );
}

export function removeDisqualified(scheduledItems: (SeriesModel | EventModel)[]) {
  return scheduledItems.filter((item) => {
    if (item.type.match(/Event/)) {
      return true;
    }
    // check for any dqs
    const dqArr = item.opponents.map((opp: any) => opp.metadata.disqualified);
    return !some(dqArr);
  });
}

// Hack used to sort tournaments in placed like ticker-nav dropdown, and results index page
export function orderTournaments(tournaments: TournamentModel[]) {
  return sortBy(tournaments, [
    (t: TournamentModel) => t.name.split(' ')[1],
    'name'
  ]);
}

export function teamLogoWithFallback(team: TeamModel): string {
  const fallbackLogo = require('common/assets/no_logo.svg') as string;
  return team.logo && team.logo.original
    ? team.logo.original
    : fallbackLogo;
}

export function layoutSize(): 'mobile' | 'medium' | 'large' {
  const browserWidth = window.innerWidth;
  const size = {
    large: 1301,
    medium: 769,
  };
  if (browserWidth >= size.large) {
    return 'large';
  } else if (browserWidth >= size.medium) {
    return 'medium';
  }
  // for mobile
  return 'mobile';
}

export function socialLinkUrl(socialLink: SocialLink, id: string) {
  return socialLink.baseUrl + id;
}

export function createFillerOpponents(amount: number) {
  return range(amount).map(() => {
    return {
      contender: {
        name: 'TBD',
        logo: {
          original: undefined
        }
      }
    };
  });
}

export function getPrettyNames(tournamentName: string) {
  return TOURNAMENT_NAMES[tournamentName]
    ? TOURNAMENT_NAMES[tournamentName]
    : { name: tournamentName, region: '' };
}
