import * as actions from 'actions/schedule';
import { DEFAULT_SCHEDULE_MODEL, ScheduleModel } from './model';

/* tslint:disable:cyclomatic-complexity */
export function schedule(state = DEFAULT_SCHEDULE_MODEL, action: actions.ScheduleActions) {
  switch (action.type) {
    case actions.SET_SCHEDULE:
      return updateScheduleResults(action.payload, state);
    default:
      return state;
  }
}

function updateScheduleResults(data: ScheduleModel, current: ScheduleModel): ScheduleModel {
  // check initial call
  // console.log('updating schedule results');
  if (current.from === undefined && current.to === undefined) {
    // console.log('initial load, using all data recieved from api');
    return data;
  }

  // some helpers this function can use
  const updatedFrom = new Date(data.from) <= new Date(current.from);
  const updatedTo = new Date(data.to) >= new Date(current.to);

  // if we already have this data, return current state
  if (!updatedFrom && !updatedTo) {
    // console.log('data requested already included in past requests');
    return current;
  }

  // empty items scenario
  if (data.items.length === 0) {
    // console.log('empty items, only updating to/from where needed');
    return {
      ...current,
      to: updatedTo ? data.to : current.to,
      from: updatedFrom ? data.from : current.from,
    }
  }

  // if both boundaries exceed
  if (updatedFrom && updatedTo) {
    // console.log('using replace since it contains entire/more data');
    return data;
  } else if (updatedTo) {
    // console.log('using append since we have newer \'to\' date');
    const idx = current.items.indexOf(data.items[0]);
    const newItems = [...current.items.slice(0, idx), ...data.items];
    return {
      ...current,
      to: data.to,
      items: newItems,
    };
  } else if (updatedFrom) {
    // console.log('using prepend since we have earlier \'from\' date');
    const idx = data.items.indexOf(current.items[0]);
    const newItems = [...data.items.slice(0, idx), ...current.items];
    return {
      ...current,
      from: data.from,
      items: newItems,
    };
  }
  // console.log('no cases met, returning old data. Here is the data', data, current);
  return current;
}
