import * as actions from 'actions/stream';
import { DEFAULT_STREAM_MODEL } from './model';

export function stream(state = DEFAULT_STREAM_MODEL, action: actions.StreamActions) {
  switch (action.type) {
    case actions.SET_LIVE:
      return {
        ...state,
        live: action.payload
      };
    case actions.SET_STREAMS:
      return {
        ...state,
        streams: [...action.payload]
      };
    case actions.SET_VIDEOS:
      return {
        ...state,
        videos: [...action.payload]
      };
    default:
      return state;
  }
}
