import * as _ from 'lodash';
import * as React from 'react';
import * as moment from 'moment';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { bindActionCreators, Dispatch } from 'redux';
import { ArticleModel } from 'tourney-sdk-react';

import { getArticleUrl } from 'ui/components/article';

require('./styles.scss');

export interface ArticlePreviewProps {
  article: ArticleModel;
}

export class ArticlePreview extends React.Component<ArticlePreviewProps, void> {
  constructor(...args: any[]) {
    super(args[0]);
  }

  public render() {
    const classes = ['article-preview'];
    const { article } = this.props;
    const fallbackImg = require('common/assets/fallback_bg.jpg');

    let stylePreview: any;
    if (!article.cover.original) {
      stylePreview = {
        backgroundImage: `url(${fallbackImg})`
      };
    } else {
      stylePreview = {
        backgroundImage: `url(${article.cover.original})`
      };
    }

    return (
      <div className={classes.join(' ')}>
        <Link to={getArticleUrl(article)}>
          <div className="article-preview__image-wrap">
            <div className="article-preview__image" style={stylePreview}/>
          </div>
          <div className="article-preview__text">
            <h2 className="article-preview__heading">{article.title}</h2>
            <div className="article-preview__date">{moment(article.published_at).format('MMMM D, YYYY')}</div>
          </div>
        </Link>
      </div>
    );
  }
}
