import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { ArticleModel } from 'tourney-sdk-react';

import { ArticlePreview } from 'ui/components/article-preview';

require('./styles.scss');

export interface ArticleSectionProps {
  articles: ArticleModel[];
}

export interface ArticleSectionState {
  displayCount: number;
}

const DISPLAY_INCREMENT = 6;

export class ArticleSection extends React.Component<ArticleSectionProps, ArticleSectionState> {
  public constructor(props: ArticleSectionProps) {
    super(props);
    this.state = {
      displayCount: DISPLAY_INCREMENT
    };
  }

  public render() {
    const classes = ['article-section'];
    const { articles } = this.props;
    const { displayCount } = this.state;
    const hasMore = articles.length > displayCount;
    const loadContent = this.loadMore.bind(this);

    const articlePreviews = articles.slice(0, displayCount).map((article: ArticleModel) => {
      return <ArticlePreview article={article} key={article.id} />;
    });
    const loadButton = hasMore
        ? <div className="article-section__more" onClick={loadContent}>Load More</div>
        : undefined;

    return (
      <div className={classes.join(' ')}>
        <h1 className="article-section__heading">News &amp; Updates</h1>
        <div className="article-section__listings">
          {articlePreviews}
        </div>
        {loadButton}
      </div>
    );
  }

  private loadMore() {
    this.setState({
      displayCount: this.state.displayCount + DISPLAY_INCREMENT
    });
  }
}
