
import { stateToHTML } from 'draft-js-export-html';
import { convertFromRaw } from 'draft-js';
import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { ArticleModel } from 'tourney-sdk-react';

import { Hero } from 'ui/components/hero';

require('./styles.scss');

export const getArticleUrl = (article: ArticleModel): string => {
  return `/news/${article.slug}`;
};

export class Article extends React.Component<any, any> {
  constructor(...args: any[]) {
    super(args[0]);
  }

  public render() {
    const classes = ['article'];
    const { article } = this.props;

    const stylePreview = {
      backgroundImage: `url(${article.cover.original})`,
    };
    const content = convertFromRaw(JSON.parse(article.body));
    let options = {
      blockRenderers: {
        'atomic:image': (block: any) => {
          let data = block.getData();
          if (data.get('src')) {
            return `<img src="${data.get('src')}" />`;
          }
        },
      },
    };
    const htmlContent = stateToHTML(content, options);

    return (
      <div className={classes.join(' ')}>
        <div className="article__hero">
          <Hero article={article} readMore={false} />
        </div>
        <div className="article__content">
          <div className="article__body" dangerouslySetInnerHTML={{ __html: htmlContent }} />
        </div>
      </div>
    );
  }
}
