import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';

import { SOCIALS, SITE_ATTRIBUTES, SocialLink } from 'common/constants';

require('./styles.scss');

export interface SiteAttribute {
  src: string;
}

export class Footer extends React.Component<any, any> {
  public render() {
    const classes = ['footer'];
    const footerLogo = require('common/assets/logo_s4_1c.svg') as string;
    const siteAttributes: JSX.Element[] = SITE_ATTRIBUTES.map((attr, idx) => {
      return <li className="footer__attribute" key={idx}><img src={attr.src}/></li>;
    });

    return (
      <div className={classes.join(' ')}>
        <div className="footer__container">
          <img className="footer__logo" src={footerLogo} />
          <div className="footer__content">
            <div className="footer__text">
              <strong>&copy; 2017 ROCKET LEAGUE CHAMPIONSHIP SERIES</strong><br/>
              ALL RIGHTS RESERVED. OPERATED BY TWITCH ESPORTS
            </div>
            <div className="social">
              <div className="social__heading">
                FOLLOW US ON SOCIAL MEDIA
              </div>
              <ul className="social__list">
                {this.renderSocials()}
              </ul>
            </div>
          </div>
          <ul className="footer__attributes">
            {siteAttributes}
          </ul>
        </div>
        {this.renderBottomFooter()}
      </div>
    );
  }

  private renderBottomFooter() {
    const footerLinks = [{
      url: '/rules',
      label: 'Rules'
    }, {
      url: 'https://www.twitch.tv/p/legal/terms-of-service/',
      label: 'Terms Of Service'
    }];

    const footerElements = footerLinks.map((item) => {
      return (
        <li key={item.label} className="bottom-footer__item">
          <a href={item.url}>
            {item.label}
          </a>
        </li>
      );
    });

    return (
      <div className="bottom-footer__container">
        <ul className="bottom-footer__list">
          {footerElements}
        </ul>
      </div>
    );
  }

  private renderSocials() {
    return SOCIALS.map((social, idx) => {
      let socialDivider;
      if (idx !== SOCIALS.length - 1) {
        socialDivider = <div className="social__divider">/</div>;
      }

      return (
        <li className="social__item" key={social.label}>
          <a href={social.url}>
            <i className={social.icon} /> {social.label}
          </a>
          {socialDivider}
        </li>
      );
    });
  }
}
