import * as React from 'react';
import { Link } from 'react-router-dom';
import { ArticleModel } from 'tourney-sdk-react';

import { Hero } from 'ui/components/hero';
import { HeroSlider } from 'ui/components/hero-slider';
import { AppModel } from 'state/model';

require('./styles.scss');

export interface HeroControllerProps {
  articles: ArticleModel[];
}

export interface HeroControllerState {
  selectedArticle?: ArticleModel;
  canAnimate?: boolean;
}

export const ANIMATION_DURATION = 1;

export class HeroController extends React.Component<HeroControllerProps, HeroControllerState> {
  public constructor(props: any) {
    super(props);
    this.state = {
      selectedArticle: this.props.articles[0],
      canAnimate: true
    };
  }

  public render() {
    const containerClasses = ['hero-controller'];
    const arrowSrc = require('common/assets/hero_arrow.svg') as string;

    const hero = <Hero key={this.state.selectedArticle.id} article={this.state.selectedArticle} readMore={true} />;
    const nextArticle = this.selectNextArticle.bind(this, 1);
    const prevArticle = this.selectNextArticle.bind(this, -1);
    return (
      <div className={containerClasses.join(' ')}>
        <HeroSlider content={hero} animationDuration={ANIMATION_DURATION}/>
        <div className="hero-controller__arrow hero-controller__arrow--left" onClick={prevArticle}>
          <img src={arrowSrc} />
        </div>
        <div className="hero-controller__arrow hero-controller__arrow--right" onClick={nextArticle}>
          <img src={arrowSrc} />
        </div>
      </div>
    );
  }

  private currentArticleIndex() {
    return this.props.articles.findIndex((item: any) => item.id === this.state.selectedArticle.id);
  }

  private selectNextArticle(direction: -1 | 1) {
    let idx = this.currentArticleIndex() + direction;
    if (idx >= this.props.articles.length) {
      idx = 0;
    } else if (idx < 0) {
      idx = this.props.articles.length - 1;
    }

    this.selectHeroSlide(this.props.articles[idx]);
  }

  private selectHeroSlide(article: ArticleModel) {
    if (!this.state.canAnimate) {
      return false;
    }
    this.setState({
      selectedArticle: article,
      canAnimate: false,
    });
    setTimeout(this.allowAnimation.bind(this), ANIMATION_DURATION * 1000);
  }

  private allowAnimation() {
    this.setState({
      canAnimate: true
    });
  }
}
