import * as React from 'react';
import { GameModel, TournamentModel } from 'tourney-sdk-react';

import { Hero } from 'ui/components/hero';

const styles = require('./styles.scss');

const SWAP_TIME = 5;
type AnimationState = 'PENDING' | 'INITIALIZED' | 'ANIMATING';

interface SliderState {
  animationState?: AnimationState;
  nextSlide?: number;
}

interface SliderProps {
  content: JSX.Element;
  animationDuration: number;
}

export class HeroSlider extends React.Component<SliderProps, SliderState> {
  private swapInterval: number;
  private oldContent: React.ReactNode = undefined;

  public constructor(props: any) {
    super(props);
    this.state = {
      animationState: 'PENDING',
    };
  }

  public componentWillUpdate(nextProps: SliderProps) {
    if (nextProps.content.key !== this.props.content.key && this.props.content !== undefined) {
      this.oldContent = this.props.content;
      this.startAnimation();
    }
  }

  public render() {
    const { content } = this.props;

    let mainSlide = ['single-slide'];
    let oldSlideClasses = ['single-slide'];

    switch (this.state.animationState) {
      case 'PENDING':
        break;
      case 'INITIALIZED':
        mainSlide = [...mainSlide, 'single-slide--new'];
        oldSlideClasses = [...oldSlideClasses, 'single-slide--old', 'single-slide--initial'];
        break;
      case 'ANIMATING':
        oldSlideClasses = [...oldSlideClasses, 'single-slide--old'];
        break;
      default:
        break;
    }

    let transitioningContent = undefined;
    if (this.oldContent) {
      transitioningContent = (
        <div className={oldSlideClasses.join(' ')}>
          {this.oldContent}
        </div>
      );
    }

    return (
      <div className="hero-slider">
        <div className={mainSlide.join(' ')}>
          {content}
        </div>
        {transitioningContent}
      </div>
    );
  }

  private startAnimation() {
    this.setState({
      animationState: 'INITIALIZED',
    });
    setTimeout(() => {
      this.setState({
        animationState: 'ANIMATING',
      });
    }, 0);
    setTimeout(() => {
      this.oldContent = undefined;
      this.setState({
        animationState: 'PENDING',
      });
    }, this.props.animationDuration * 1000);
  }
}
