import * as React from 'react';
import { Link } from 'react-router-dom';
import { ArticleModel } from 'tourney-sdk-react';
import * as moment from 'moment';

import { AppModel } from 'state/model';
import { getArticleUrl } from 'ui/components/article';

require('./styles.scss');

export interface HeroProps {
  article: ArticleModel;
  readMore: boolean;
}

export class Hero extends React.Component<HeroProps, any> {
  public render() {
    const { article, readMore } = this.props;
    const containerClasses = ['hero'];
    const fallbackImg = require('common/assets/fallback_bg.jpg');

    let heroStyle: any;
    if (!article.cover.original) {
      heroStyle = {
        backgroundImage: `url(${fallbackImg})`
      };
    } else {
      heroStyle = {
        backgroundImage: `url(${article.cover.original})`
      };
    }

    const readMoreElement = readMore
      ? (
        <div className="hero__more">
            <Link to={getArticleUrl(article)}>
              Read More
            </Link>
        </div>)
      : undefined;

    return (
      <div className={containerClasses.join(' ')} style={heroStyle}>
        <div className="hero__text">
          <div className="hero__date">{moment(article.published_at).format('MMMM D, YYYY')}</div>
          <div className="hero__title">{article.title}</div>
          {readMoreElement}
        </div>
      </div>
    );
  }
}
