import { keys } from 'lodash';
import * as React from 'react';

import { TEAM_SOCIALS, SocialLink } from 'common/constants';
import { socialLinkUrl } from 'common/helpers';

require('./styles.scss');

export class Player extends React.Component<any, any> {
  public render() {
    const { player } = this.props;

    const playerPhoto = player.photo && player.photo.original
      ? player.photo.original
      : require('common/assets/player_fallback.png') as string;
    return (
      <div className="player-detail__container">
        <div className="player-detail__top-contents">
          <div className="player-detail__image" style={{ backgroundImage: `url(${playerPhoto})` }}>
            <div className="player-detail__image-ratio"/>
          </div>
          <ul className="player-detail__socials">
            {this.renderSocials()}
          </ul>
        </div>
        <div className="player-detail__handle">
          {player.handle}
        </div>
        <div className="player-detail__name">
          {player.first_name + ' ' + player.last_name}
        </div>
      </div>
    );
  }

  private renderSocials() {
    const { player } = this.props;

    return TEAM_SOCIALS
      .filter((social: SocialLink) => player.social[social.label])
      .map((social: SocialLink) => {
          return (
            <li className="player-detail__social-item">
               <a href={socialLinkUrl(social, player.social[social.label])}>
                <i className={social.icon} />
               </a>
            </li>
          );
      });
  }
}
