import * as _ from 'lodash';
import * as React from 'react';
import * as moment from 'moment';
import { SeriesModel } from 'tourney-sdk-react';

import { ScheduleSeries } from 'ui/components/schedule-series';

require('./styles.scss');

export class ScheduleBroadcast extends React.Component<any, any> {
  constructor(props: any) {
    super(props);
  }

  public render() {
    const { event } = this.props;
    const westcoastTime = moment(event.starts_at).tz('America/Los_Angeles');
    const localTime = moment(event.starts_at).tz(moment.tz.guess());
    const logoStyles: any = {};
    if (event.logo.original !== '') {
      logoStyles.backgroundImage = `url(${event.logo.original})`;
    }

    let localTimeElement: JSX.Element;
    if (westcoastTime.format('YYYY-MM-DD HH:mm') !== localTime.format('YYYY-MM-DD HH:mm')) {
      localTimeElement = (<div>{localTime.format('LT')} <span>{localTime.format('z')}</span></div>);
    }
    return (
      <section className="schedule-broadcast__container">
        <div className="schedule-broadcast__logo-container" style={logoStyles}>
          {/* <img src={} className="schedule-broadcast__logo"/> */}
        </div>
        <div className="schedule-broadcast__content">
          <div className="schedule-broadcast__contents">
            <div className="schedule-broadcast__label">
              <div className="schedule-broadcast__title">{event.title}</div>
              <div className="schedule-broadcast__description">{event.description}</div>
            </div>

            <div className="schedule-broadcast__actions">
              <div className="schedule-broadcast__times">
                {westcoastTime.format('LT')} <span>{westcoastTime.format('z')}</span>
                {localTimeElement}
              </div>
              <div className="schedule-broadcast__twitch-button">
                <a href={event.twitch_url}>
                Watch
                </a>
              </div>
            </div>
          </div>
        </div>
      </section>
    );
  }
}
