import * as _ from 'lodash';
import * as React from 'react';
import * as moment from 'moment';
import { SeriesModel } from 'tourney-sdk-react';

import { ScheduleSeries } from 'ui/components/schedule-series';

require('./styles.scss');

export interface ScheduleEventProps {
  tournamentName: string;
  stageName: string;
  tournamentLogo: string;
  series: SeriesModel[];
  selected: boolean;
}

export class ScheduleEvent extends React.Component<ScheduleEventProps, any> {
  constructor(props: any) {
    super(props);
  }

  public render() {
    const { tournamentName, stageName, tournamentLogo, series, selected } = this.props;
    const seriesElements = series.map((s: SeriesModel) => <ScheduleSeries series={s} key={s.id} />);

    return (
      <section className="schedule-event__container">
        <div className="schedule-event__heading">
          <img src={tournamentLogo} className="schedule-event__logo"/>
          <div className="schedule-event__tournament">{tournamentName}</div>
          <div className="schedule-event__stage">{stageName}</div>
        </div>
        <div className="schedule-event__series">
          {seriesElements}
        </div>
      </section>
    );
  }
}
