import * as _ from 'lodash';
import * as React from 'react';
import * as moment from 'moment';
import { Link } from 'react-router-dom';
import { SeriesModel } from 'tourney-sdk-react';

import { ScheduleEvent, ScheduleEventProps } from 'ui/components/schedule-event';
import { ScheduleBroadcast } from 'ui/components/schedule-broadcast';

require('./styles.scss');

export class ScheduleEvents extends React.Component<any, any> {
  constructor(props: any) {
    super(props);
    this.state = {
      containerHeight: 0
    };
  }

  public componentDidMount() {
    setTimeout(this.updateContainerHeight.bind(this), 0);
  }

  public componentDidUpdate(lastProps: any) {
    if (this.props.selectedDate !== lastProps.selectedDate) {
      this.updateContainerHeight();
    }
  }

  public render() {
    const { availableDates, selectedDate, seriesByDate, tournamentStages } = this.props;
    const { containerHeight } = this.state;
    const allEventDays = this.groupIntoEvents().map((data: any, idx: number) => {
      let groups: JSX.Element[];
      const orderedGroups = _.sortBy(data.groupings, 'scheduled_at');

      groups = orderedGroups.map((obj: any) => {
        if (obj.type === 'broadcast') {
          return <ScheduleBroadcast {...obj.data} key={obj.data.event.id} />;
        } else if (obj.type === 'series') {
          const key = `${obj.scheduled_at}-${obj.data.tournamentName}-${obj.data.stageName}`;
          return <ScheduleEvent {...obj.data} key={key} />;
        }
      });

      const classes = ['schedule-events__container'];
      if (data.selected) {
        classes.push('schedule-events__container--active');
      }

      return (
        <div className={classes.join(' ')} key={idx}>
          {groups}
        </div>
      );
    });

    return (
      <section style={{ height: containerHeight }} className="schedule-events__contents">
        {allEventDays}
      </section>
    );
  }

  // This groups everything into tournament stage groupings within a date.
  private groupIntoEvents(): any {
    const { availableDates, selectedDate, seriesByDate, tournamentStages, tournamentsById } = this.props;

    return availableDates.map((filterDate: string) => {
      let results = {
        selected: filterDate === selectedDate,
        groupings: [] as any[],
        // events: [] as any[],
        // seriesGroup: [] as any[]
      };

      seriesByDate[filterDate].forEach((item: any) => {
        if (item.type === 'Event') {
          results.groupings = [...results.groupings, {
            type: 'broadcast',
            data: { event: item },
            scheduled_at: item.starts_at
          }];

          // results.events = [...results.events, <ScheduleBroadcast event={item} />];
        }
      });

      const data: any = {
        stageName: undefined,
        tournamentLogo: require('common/assets/logo_s4.svg') as string,
        series: [],
      };

      // TODO:
      // discard any bad data (this should be able to be removed once we have it pointing to correct `season`)
      const filteredSeries = _.filter(seriesByDate[filterDate], (s: SeriesModel) => s.tournament_stage_id);
      const seriesByStage = _.groupBy(filteredSeries, 'tournament_stage_id');
      const tournamentStagesById: any = _.keyBy(tournamentStages, 'id');
      const seriesGroup = _.keys(seriesByStage).map((stageId: string): any => {
        const tournamentStage = tournamentStagesById[stageId];
        const tournament = tournamentsById[tournamentStage.tournament_id];
        // quick add for logo hack
        // if (tournament.name.match(/RLRS/)) {
        //   data.tournamentLogo = require('common/assets/logo-rlrs.svg') as string;
        // }
        // data.tournamentLogo = tournament.logo;
        let tournamentLogo = tournament.logo.original
          ? tournament.logo.original
          : require('common/assets/logo_s4.svg') as string;
        return {
          type: 'series',
          scheduled_at: seriesByStage[stageId] ? seriesByStage[stageId][0].scheduled_at : undefined,
          data: {
            ...data,
            tournamentLogo,
            tournamentName: tournament.name,
            stageName: tournamentStage.name,
            series: seriesByStage[stageId] || [],
            selected: selectedDate === filterDate
          }
        };
      });
      results.groupings = [...results.groupings, ...seriesGroup];
      return results;
    });
  }

  private updateContainerHeight() {
    const activeElement = document.getElementsByClassName('schedule-events__container--active')[0];
    const containerHeight = activeElement ? activeElement.clientHeight : 0;
    this.setState({
      containerHeight
    });
  }
}
