import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';

import { SPONSORS } from 'common/constants';

require('./styles.scss');

export interface Sponsor {
  title: string;
  src: string;
}

export class SponsorBar extends React.Component<any, any> {

  public render() {
    const sponsorItems: JSX.Element[] = SPONSORS.map((sponsor) => {
      const classes = ['sponsor-bar__item', `sponsor-bar__item--${sponsor.title}`];
      return (
        <div className={classes.join(' ')} key={sponsor.title}>
          <img src={sponsor.src} />
        </div>
      );
    });

    return (
      <div className="sponsor-bar">
        {sponsorItems}
      </div>
    );
  }
}
