import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';

import {
  TournamentStageSchema,
  TournamentStageModel,
  TeamSchema,
  TeamModel
} from 'tourney-sdk-react';

import { TeamLink } from 'ui/components/team-link';

require('./styles.scss');

export interface StandingsProps {
  tournamentStage: TournamentStageModel;
  teamsById: {[key: string]: TeamModel};
}

export class Standings extends React.Component<StandingsProps, any> {

  public render() {
    const { tournamentStage } = this.props;
    const standings = tournamentStage.standings.map(this.renderStanding.bind(this));
    return (
      <div className="stage-standings__container">
        {/* <h2>{tournamentStage.name}</h2> */}
         {/* <div className="stage-standings__title">{tournamentStage.name}</div> */}
        <div className="stage-standings__header">
          <div className="stage-standings__left-content">
            <div className="stage-standings__header-place">PLACE</div>
            <div className="stage-standings__header-team">TEAM</div>
          </div>
          <div className="stage-standings__right-content">
            <div className="stage-standings__header-series">
              MATCHES
              <div className="stage-standings__header-matches">
                GAMES
              </div>
            </div>
          </div>
        </div>
        <ul className="stage-standings__list">
          {standings}
        </ul>
      </div>
    );
  }

  private renderStanding(standing: any, idx: number) {
    const team = this.props.teamsById[standing.contender.id];
    if (!team) {
      return undefined;
    }
    const rank = idx + 1;
    const rankingStyle = this.getRankStyle(rank);
    const teamLogo = team.logo.original
      ? team.logo.original
      : require('common/assets/no_logo.svg');
    return (
        <li className="stage-standings__item" key={idx}>
          <div className="stage-standings__left-content">
            <div className={['stage-standings__place', rankingStyle].join(' ')}>{rank}</div>
            <div className="stage-standings__team">
              <TeamLink team={team}>
                <img src={teamLogo} className="stage-standings__team-logo"/>
                {team.name}
              </TeamLink>
            </div>
          </div>
          <div className="stage-standings__right-content">
            <div className="stage-standings__result">
              {standing.wins} - {standing.losses}
              <div className="stage-standings__match-result">{standing.match_wins} - {standing.match_losses}</div>
            </div>
          </div>
        </li>
    );
  }

  // returns style for style
  private getRankStyle(place: number) {
    const { tournamentStage } = this.props;
    // constants with Regex check;
    // [top, middle]
    const RLCS_FORMAT = [2, 6];
    const RLRS_FORMAT = [2, 4];
    const format = tournamentStage.tournament.name.match(/RLCS/)
      ? RLCS_FORMAT
      : RLRS_FORMAT;

    if (place <= format[0]) {
      return 'stage-standings__place--top';
    } else if (place <= format[1]) {
      return 'stage-standings__place--middle';
    }
    return 'stage-standings__place--bottom';
  }
}
