import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { bindActionCreators, Dispatch } from 'redux';

import { StreamProps, VideoProps } from 'state/stream/model';
import { addCommasToNumber } from 'common/helpers';

require('./styles.scss');

export interface StreamPreviewProps {
  stream?: StreamProps;
  video?: VideoProps;
}

export class StreamPreview extends React.Component<StreamPreviewProps, void> {
  constructor(...args: any[]) {
    super(args[0]);
  }

  public render() {
    let classes = ['stream-preview'];
    const { stream, video } = this.props;

    let item;
    let views: string;
    if (stream) {
      item = stream;
      views = `${addCommasToNumber(item.viewers)} Viewers`;
      classes = [...classes, 'stream-preview--stream'];
    } else {
      item = video;
      views = `${addCommasToNumber(item.views)} Views`;
    }

    const stylePreview = {
      backgroundImage: `url(${item.preview})`,
    };

    return (
      <div className={classes.join(' ')}>
        <a href={item.link}>
          <div className="stream-preview__image-wrap">
            <div className="stream-preview__image" style={stylePreview}/>
          </div>
          <div className="stream-preview__text-container">
            <div className="stream-preview__text">
              <h2 className="stream-preview__heading">{item.title}</h2>
              <div className="stream-preview__viewers">{views}</div>
            </div>
          </div>
        </a>
      </div>
    );
  }
}
