
import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';

import { StreamModel, StreamProps, VideoProps } from 'state/stream/model';
import { StreamPreview } from 'ui/components/stream-preview';

require('./styles.scss');

const MAX_WATCH_ITEMS = 4;

export interface StreamSectionProps {
  stream: StreamModel;
}

export class StreamSection extends React.Component<StreamSectionProps, void> {
  public render() {
    const classes = ['stream-section'];
    const { stream } = this.props;

    const streamPreviews = stream.streams.map((st: StreamProps) => {
      return <StreamPreview stream={st} key={st.title} />;
    });

    const videoFill = stream.videos.slice(0, MAX_WATCH_ITEMS - streamPreviews.length);
    const videoPreviews = videoFill.map((video: VideoProps) => {
      return <StreamPreview video={video} key={video.id} />;
    });

    return (
      <div className={classes.join(' ')}>
        <h1 className="stream-section__heading">Watch</h1>
        <div className="stream-section__listings">
          {streamPreviews}
          {videoPreviews}
        </div>
      </div>
    );
  }
}
