import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { bindActionCreators, Dispatch } from 'redux';
import {
  TeamModel
} from 'tourney-sdk-react';

require('./styles.scss');

export interface TeamLinkProps {
  team: TeamModel;
}

export class TeamLink extends React.Component<TeamLinkProps, void> {
  public render() {
    const { team } = this.props;

    if (team.slug) {
      return (
        <Link className="team-link" to={`/teams/${team.slug}`}>
          {this.props.children}
        </Link>
      );
    }
    return (
      <span>
        {this.props.children}
      </span>
    );

  }
}
