import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import {
  TeamModel,
  TournamentModel,
} from 'tourney-sdk-react';

import {
  TEAM_SOCIALS,
  SocialLink,
  TEAM_SECTIONS,
  TICKER_THRESHOLD,
  TEAM_NAV_HEIGHT,
  DESKTOP_NAVIGATION_HEIGHT
} from 'common/constants';
import { layoutSize } from 'common/helpers';
import { TeamStanding } from 'ui/components/team-standing';
import { TeamSocialLinks } from 'ui/components/team-socials';

require('./styles.scss');

export interface TeamNavProps {
  team: TeamModel;
  tournaments: TournamentModel[];
}

export interface TeamNavState {
  scrolledThreshold: boolean;
}

export class TeamNav extends React.Component<TeamNavProps, any> {
  public boundScrollThreshold: (event: any) => {};
  public constructor(props: any) {
    super(props);
    this.state = {
      scrolledThreshold: false
    };
    this.boundScrollThreshold = this.checkScrollThreshold.bind(this);
  }

  public componentDidMount() {
    document.addEventListener('scroll', this.boundScrollThreshold);
  }

  public componentWillUnmount() {
    document.removeEventListener('scroll', this.boundScrollThreshold);
  }

  public render() {
    const { team, tournaments } = this.props;
    const { scrolledThreshold } = this.state;
    const teamLogo = team.logo.original
      ? team.logo.original
      : require('common/assets/no_logo.svg');

    const classes = ['team-nav'];
    if (scrolledThreshold) {
      classes.push('scrolled');
    }
    return (
      <div className={classes.join(' ')} id="team-nav">
        <div className="team-nav__content">
          <div className="team-nav__logo" style={{ backgroundImage: `url(${teamLogo})` }} />
          <div className="team-nav__name">{team.name}</div>
          <TeamStanding team={team} tournaments={tournaments}/>
          <TeamSocialLinks team={team} />
          {this.renderSectionHeading()}
        </div>
      </div>
    );
  }

  private checkScrollThreshold() {
    const pastThreshold = window.scrollY > TICKER_THRESHOLD;
    if (this.state.scrolledThreshold !== pastThreshold) {
      this.setState({
        scrolledThreshold: pastThreshold
      });
    }
  }

  private renderSectionHeading() {
    const items = TEAM_SECTIONS.map((section) => {
      const scrollTo = this.scrollToSection.bind(this, section);
      return (
        <li className="team-nav__section-item" onClick={scrollTo}>
          {section}
        </li>
      );
    });

    return (
      <ul className="team-nav__sections">
        {items}
      </ul>
    );
  }

  private scrollToSection(section: string) {
    if (section === 'about') {
      return window.scrollTo(0, 0);
    }

    const location = document.getElementById(section).offsetTop;
    const offset = DESKTOP_NAVIGATION_HEIGHT + TEAM_NAV_HEIGHT;
    window.scrollTo(0, location - offset);
  }
}
