import * as _ from 'lodash';
import * as React from 'react';
import * as moment from 'moment-timezone';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { bindActionCreators, Dispatch } from 'redux';
import {
  denormalize,
  SeriesSchema,
  ScheduledEvent,
  SeriesModel,
  TournamentStageSchema,
  TournamentStageModel,
  getTournaments,
  TournamentSchema,
  TournamentModel,
  getTeams,
 } from 'tourney-sdk-react';

import { removeDisqualified } from 'common/helpers';
import { AppModel } from 'state/model';
import { ScheduleSeries } from 'ui/components/schedule-series';

require('./styles.scss');

export class TeamScheduleComponent extends React.Component<any, any> {
  public static mapStateToProps(state: AppModel, ownProps: any) {
    const orderedSeries = removeDisqualified(denormalize(state.schedule.items, [ScheduledEvent], state.tourney));
    const filteredSeries = orderedSeries.filter((item: any) => {
      // filter out events
      if (!item.opponents) {
        return false;
      }
      const teamIds = item.opponents.map((opp: any) => opp.contender.id);
      return teamIds.indexOf(ownProps.team.id) !== -1;
    });
    const loading = state.schedule.items.length === 0;
    return {
      filteredSeries,
      loading
    };
  }

  public static mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: AppModel) {
    return {
      dispatch
    };
  }

  public render() {
    const { filteredSeries } = this.props;
    const allSeries = filteredSeries.map((series: SeriesModel) => <ScheduleSeries series={series} showDate={true}/>);
    return (
      <section className="team-schedule">
        <div className="team-schedule__contents">
          {allSeries}
        </div>
        <div className="team-schedule__more">
          <Link to="/schedule">
            View Entire Schedule <i className="fa fa-chevron-right" />
          </Link>
        </div>
      </section>
    );
  }
}

export const TeamSchedule = connect(TeamScheduleComponent.mapStateToProps, TeamScheduleComponent.mapDispatchToProps)(TeamScheduleComponent);
