import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import {
  TeamModel,
} from 'tourney-sdk-react';

import { TEAM_SOCIALS, SocialLink } from 'common/constants';
import { socialLinkUrl } from 'common/helpers';

require('./styles.scss');

export interface TeamSocialLinksProps {
  team: TeamModel;
}

export class TeamSocialLinks extends React.Component<TeamSocialLinksProps, any> {
  public render() {
    const { team } = this.props;
    const socialItems: SocialLink[] = [];
    TEAM_SOCIALS.forEach((social) => {
      const url = team.social[social.label];
      if (url) {
        socialItems.push({ ...social, url });
      }
    });
    const socialElements = socialItems.map((s) => this.renderSocialItem(s));
    return (
      <ul className="team-nav__socials">
        {socialElements}
      </ul>
    );
  }

  private renderSocialItem(social: SocialLink) {
    return (
      <li key={social.label} className="team-nav__social-item">
        <a href={socialLinkUrl(social, social.url)}>
          <i className={social.icon} />
        </a>
      </li>
    );
  }
}
