import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import {
  TeamModel,
  TournamentModel,
  TournamentStageModel,
} from 'tourney-sdk-react';

require('./styles.scss');

export interface TeamStandingProps {
  team: TeamModel;
  tournaments: TournamentModel[];
}

export class TeamStanding extends React.Component<TeamStandingProps, any> {
  public render() {
    const { team } = this.props;
    const { standing, tournamentStage } = this.findTournamentAndStanding();
    // if they don't have a group stage to show
    if (!tournamentStage) {
      return <div/>;
    }
    const stageLogo = tournamentStage.tournament.logo.original;
    return (
      <div className="team-standing__container">
        <img className="team-standing__tournament-logo" src={stageLogo} />
        <div className="team-standing__rank">#{standing}</div>
        <div className="team-standing__text">
          <div className="team-standing__tournament">{tournamentStage.tournament.name}</div>
          <div className="team-standing__stage">{tournamentStage.name}</div>
        </div>
      </div>
    );
  }

  private findTournamentAndStanding() {
    const { team, tournaments } = this.props;
    const allStages = tournaments.reduce((memo, t: TournamentModel) => {
      const validStages = t.stages.filter((stage: TournamentStageModel) => stage.type === 'TournamentStage::RoundRobin');
      return [...memo, ...validStages];
    }, []);
    let tournamentStage: TournamentStageModel;
    let standing: number;
    allStages.forEach((stage, idx) => {
      const result = _.findIndex(stage.standings, (s: any) => {
        return s.contender.id === team.id;
      });
      if (result !== -1) {
        standing = result + 1;
        tournamentStage = stage;
      }
    });

    return {
      standing,
      tournamentStage
    };
  }
}
