import * as _ from 'lodash';
import * as React from 'react';
import * as moment from 'moment';
import { Link } from 'react-router-dom';

import { createFillerOpponents } from 'common/helpers';
import { TeamLink } from 'ui/components/team-link';

require('./styles.scss');

export class TickerSeries extends React.Component<any, any> {
  constructor(props: any) {
    super(props);
  }

  public render() {
    const { series } = this.props;
    let opponents = series.opponents;
    if (opponents.length < 2) {
      const fillers = createFillerOpponents(2 - opponents.length);
      opponents = [...opponents, ...fillers];
    }
    const teams = opponents.map((opp: any) => this.renderTeam(opp, series));
    let time: JSX.Element = undefined;
    if (!this.shouldShowScore()) {
      const westcoastTime = moment(series.scheduled_at).tz('America/Los_Angeles');
      time = (
        <div className="ticker-series__time">
          <span className="date">{westcoastTime.format('ll')}</span>
          <br/>
          <span className="time">{westcoastTime.format('LT')}</span>
          <span className="tz">{westcoastTime.format('z')}</span>
        </div>
      );
    }
    return (
      <div className="ticker-series__container">
        {teams}
        {time}
      </div>
    );
  }

  private shouldShowScore(): boolean {
    const { series } = this.props;
    const scoreArr = series.opponents.map((opp: any) => opp.score);
    return _.some(scoreArr);
  }

  private renderTeam(opponent: any, series: any) {
    const tempLogo = require('common/assets/no_logo.svg') as string;
    let logo: string = opponent.contender.logo.original ? opponent.contender.logo.thumb : tempLogo;
    const logoElement = <div className="ticker-series__logo" style={{ backgroundImage: `url(${logo})` }}/>;
    let score: JSX.Element = undefined;
    if (this.shouldShowScore()) {
      score = (
        <div className="ticker-series__score">
          {opponent.score}
        </div>
      );
    }

    return (
      <div className="ticker-series__team" key={opponent.id}>
        <TeamLink team={opponent.contender}>
          {logoElement}
          <span className="ticker-series__name">
            {opponent.contender.name}
          </span>
        </TeamLink>
        {score}
      </div>
    );
  }
}
