import * as React from 'react';
import { getPrettyNames } from 'common/helpers';

import './styles.scss';

export class TournamentHeader extends React.Component<any, any> {
  public render() {
    const { tournament } = this.props;
    let prettyName = getPrettyNames(tournament.name);
    const logo = tournament.logo.original
      ? tournament.logo.original
      : require('common/assets/logo_s4.svg');
    let bgStyle = { backgroundImage: `url(${logo})` };
    // optional classes
    return (
      <div className="tournament-header__heading">
        <div className="tournament-header__heading-logo" style={bgStyle} />
        <div className="tournament-header__heading-tournament">
          <div className="tournament-header__name">{prettyName.name}</div>
          {prettyName.region ? <div className="tournament-header__region">{prettyName.region}</div> : undefined}
          {this.props.children}
        </div>
      </div>
    );
  }
}
