import 'babel-polyfill';
import { config } from 'config';

import * as Rollbar from '../vendor/rollbar.umd.nojson.min.js';
// See docker/nginx/run.sh on why this is here.
// if (process.env.NODE_ENV !== 'development') {
//   const rollbarConfig = {
//     accessToken: process.env.ROLLBAR_ACCESS_TOKEN,
//     captureUncaught: true,
//     captureUnhandledRejections: false,
//     payload: {
//       environment: process.env.NODE_ENV,
//       client: {
//         javascript: {
//           source_map_enabled: true,
//           code_version: process.env.VERSION,
//           guess_uncaught_frames: true
//         }
//       }
//     }
//   };
//   Rollbar.init(rollbarConfig);
// }

import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { BrowserRouter as Router, Route, Link } from 'react-router-dom';
import * as Tourney from 'tourney-sdk-react';

import { store } from 'state/store';
import { App } from 'ui/app';
import { ScrollToTop } from 'ui/components/scroll-to-top';
import { ArticleDetail } from 'ui/pages/article-detail';
import { TeamListPage } from 'ui/pages/teams/list';
import { TeamDetailPage } from 'ui/pages/teams/detail';
import { NewsPage } from 'ui/pages/news';
import { SchedulePage } from 'ui/pages/schedule';
import { ResultsListPage } from 'ui/pages/results';
import { TournamentResultsListPage } from 'ui/pages/tournaments/list';
import { TournamentResultsPage } from 'ui/pages/tournaments/detail';

(require('smoothscroll-polyfill') as any).polyfill();

Tourney.config.apiUrl = config.apiUrl;
Tourney.config.apiClientId = config.apiClientId;
Tourney.config.store = store;

Tourney.config.apiUrl = config.apiUrl;
Tourney.config.apiClientId = config.apiClientId;
Tourney.config.store = store;

ReactDOM.render(
  <Provider store={store}>
    <Router>
      <ScrollToTop>
        <App>
          <Route exact={true} path="/" component={NewsPage}/>
          <Route exact={true} path="/news" component={NewsPage}/>
          <Route path="/news/:slug" component={ArticleDetail}/>
          <Route exact={true} path="/schedule" component={SchedulePage}/>
          <Route exact={true} path="/teams" component={TeamListPage}/>
          <Route path="/teams/:id" component={TeamDetailPage}/>
          <Route exact={true} path="/results" component={ResultsListPage}/>
          <Route exact={true} path="/tournaments" component={TournamentResultsListPage}/>
          <Route path="/tournaments/:tournamentSlug" component={TournamentResultsPage}/>
        </App>
      </ScrollToTop>
    </Router>
  </Provider>,
  document.getElementById('main')
);
