import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { bindActionCreators, Dispatch } from 'redux';

import { fetchArticles } from 'actions';
import { AppModel } from 'state/model';
import { Article } from 'ui/components/article';
import { denormalize, ArticleSchema, ArticleModel } from 'tourney-sdk-react';

export class ArticleDetailComponent extends React.Component<any, any> {
  public static mapStateToProps(state: AppModel, ownProps: any) {
    // check if in store already
    const articles = denormalize(state.article.articles, [ArticleSchema], state.tourney);
    const loading = articles.length === 0;
    let article: ArticleModel;
    if (!loading) {
      article = articles.find((art: ArticleModel) => {
        return art.slug === ownProps.match.params.slug
      });
    }
    return {
      article,
      loading
    };
  }
  public static mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: AppModel) {
    return bindActionCreators({
      fetchArticles
    }, dispatch);
  }

  constructor(props: any) {
    super(props);
  }

  public componentDidMount() {
    if (this.props.loading) {
      this.props.fetchArticles();
    }
  }

  public render() {
    const classes = ['article-detail'];
    const { article, loading } = this.props;
    const backButton = require('common/assets/hero_arrow.svg') as string;

    let articleDetail: JSX.Element;
    if (article) {
      articleDetail = <Article article={article} />;
    }

    return (
      <div className={classes.join(' ')}>
        <Link to="/news" className="article-detail__back">
          <img src={backButton}/>More News
        </Link>
        {articleDetail}
      </div>
    );
  }
}

export const ArticleDetail = connect(ArticleDetailComponent.mapStateToProps, ArticleDetailComponent.mapDispatchToProps)(ArticleDetailComponent);
