#!/bin/bash
#
# Requires 
# awscli >= 1.11.91

name=rlcs-client
region=us-west-2
ecr_staging=157383839067.dkr.ecr.us-west-2.amazonaws.com/rlcs
# TODO detroy old rlcs
ecr_production=954268612818.dkr.ecr.us-west-2.amazonaws.com/rlcs-client
branch=`git rev-parse --abbrev-ref @`
version=`git rev-parse --short HEAD`
branch=HEAD

function ensure {
    "$@"
    local status=$?
    if [ $status -ne 0 ]; then
        echo "error with $1" >&2
        exit 1
    fi
    return $status
}

read -p "Build app? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  export NODE_ENV=production
  export VERSION=$version
  export ROLLBAR_SERVER_ACCESS_TOKEN=8491ce4b67bd4258972205373b1aa3be
  export ROLLBAR_ACCESS_TOKEN=a1926a8cb79b4c87b132602715b1cf15
  case "$1" in
    staging)
      export API_CLIENT_ID=bcYXa1F1EZi
      export API_URL=https://api.rlcs.gg
      export CMS_GAME_ID=22cb675a-3778-48ce-9f2f-c6c043102456
      export TWITCH_CALLBACK_URL=https://rlcs.gg/auth/callback/twitch
      # export API_CLIENT_ID=OduT193Echi
      # export API_URL=https://api.staging.rlcs.gg
      # export CMS_GAME_ID=feea15d2-b80a-4992-ac22-eb752d17a24b
      # export TWITCH_CALLBACK_URL=http://staging.rlcs.gg/auth/callback/twitch
      ;;
    production)
      export API_CLIENT_ID=bcYXa1F1EZi
      export API_URL=https://api.rlcs.gg
      export CMS_GAME_ID=22cb675a-3778-48ce-9f2f-c6c043102456
      export TWITCH_CALLBACK_URL=https://rlcs.gg/auth/callback/twitch
      ;;
  esac
  ensure docker run \
    -v `pwd`:/app \
    -e NODE_ENV \
    -e VERSION \
    -e CMS_GAME_ID \
    -e ROLLBAR_SERVER_ACCESS_TOKEN \
    -e ROLLBAR_ACCESS_TOKEN \
    -e API_CLIENT_ID \
    -e API_URL \
    -e TWITCH_CALLBACK_URL \
    node:7.7 /bin/sh -c "cd /app && yarn install && npm install node-sass && yarn build && rm -f dist/*map"
fi

read -p "Build container? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  ensure docker build -t ${name}:latest -f docker/Dockerfile .
fi

read -p "Push docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  case "$1" in
    staging)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-dev`
      if [ $? -ne 0 ]; then `aws ecr get-login --no-include-email --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_staging}:latest
      ensure docker push ${ecr_staging}:latest
      ;;
    production)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-aws`
      if [ $? -ne 0 ]; then `aws ecr get-login --no-include-email --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_production}:latest
      ensure docker push ${ecr_production}:latest
      ;;
  esac
fi

