var players = require('./players')
var fs = require('fs');
// run this file to update player ids

const getContent = function(url) {
  return new Promise((resolve, reject) => {
    const lib = url.protocol === 'https:' ? require('https') : require('http');
    const request = lib.get(url, (response) => {
      if (response.statusCode < 200 || response.statusCode > 299) {
         reject(new Error('Failed to load page, status code: ' + response.statusCode));
       }
      const body = [];
      response.on('data', (chunk) => body.push(chunk));
      response.on('end', () => resolve(body.join('')));
    });
    request.on('error', (err) => reject(err))
    })
};

const saveJSON = function(location, data){
  fs.writeFile(location, data, function(err) {
    if(err) {
        return console.log(err);
    }
    console.log("The file was saved!");
  }); 
}

let playerStr = players.reduce(function(memo, obj){
  return memo + ',' + obj;
}, "").substring(1);

getContent({
  protocol: 'https:',
  host: 'api.twitch.tv',
  path: `/kraken/users?login=${playerStr}`,
  headers: {
    'Accept': 'application/vnd.twitchtv.v5+json',
    'Client-ID': '8n40gll3d120n6xxe5hr8n0a31sezo1'
  }
})
  .then(function(obj) {
    let users = JSON.parse(obj).users;
    let ids = users.map((user) => { return user._id; });
    saveJSON('../app/common/constants/playerIds.json', JSON.stringify(ids));
  })
  .catch(function(err){
    console.log(err);
  });




