provider "aws" {
    region = "us-west-2"
    profile = "twitch-esports-dev"
}

provider "aws" {
  region = "us-west-2"
  profile = "twitch-esports-aws"
  alias = "twitch-esports-aws"
}

module "common" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/variables/twitch-esports-dev/"
}

data "terraform_remote_state" "dev" {
  backend = "s3"
  config {
    bucket = "twitch-esports-dev"
    key = "tfstate/esports/terraform/dev/raw"
    profile = "twitch-esports-dev"
    region = "us-east-1"
  }
}

resource "aws_ecr_repository" "rlcs" {
  name = "rlcs"
}

data "template_file" "task_definition" {
  template = "${file("task-definitions/rlcs.json")}"
  vars {
    name = "rlcs"
    region = "us-west-2"
    image = "${replace(aws_ecr_repository.rlcs.repository_url, "https://", "")}:latest"
    container_port = 80
    cpu = 256
    mem = 256
  }
}

resource "aws_ecs_task_definition" "default" {
  family = "rlcs"
  container_definitions = "${data.template_file.task_definition.rendered}"
}

module "service" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/service?ref=00bcb20fa153152c811b6948d83a7085eaaf50b9"
  name = "rlcs"
  prefix = "rlcs"
  container_port = "80"
  alb = true
  # alb_ssl = true
  env = "staging"
  cluster = "programs"
  # staging.rlcs.gg us-west-2
  certificate_arn = "arn:aws:acm:us-west-2:157383839067:certificate/1dc70f4b-e723-49fd-bb88-c5f5faba9a36"
  task_definition = "${aws_ecs_task_definition.default.arn}"
  vpc_id = "${lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "vpc_id")}"
  subnet_ids = "${split(",", lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "subnet_ids"))}"
  security_group_id = "${lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "security_group_id")}"
  internal_zone_id = "${data.terraform_remote_state.dev.route53_zone_services_internal}"
  external_zone_id = "${data.terraform_remote_state.dev.route53_zone_services_external}"
  # alarm_sns_topic_arn = "${data.terraform_remote_state.dev.alarm_sns_topic_arn}"
}

resource "aws_route53_record" "production" {
  provider = "aws.twitch-esports-aws"
  # zone_id = "Z34P3OL4J5VSVE" # rocketleagueesports.com
  zone_id = "Z140IZPCS2HRJW" # rlcs.gg
  name = "staging"
  type = "A"

  alias {
    name = "${module.service.alb_dns_name}"
    zone_id = "${module.service.alb_zone_id}"
    evaluate_target_health = false
  }
}


output "ecr_url" {
  value = "${aws_ecr_repository.rlcs.repository_url}"
}
