
import {
  dqSeries,
  unstartedSeries,
  completedSeries,
  liveSeries,
  event,
  TOURNAMENTS
} from '../constants';
import { removeDisqualified, orderTournaments } from 'common/helpers';

describe('Helpers', () => {
  describe('Removing Disqualified', () => {
    it('should ignore events and non-dq series in', () => {
      const result = removeDisqualified([event, liveSeries, completedSeries, unstartedSeries, dqSeries]);
      expect(result).not.toContain(dqSeries);
      expect(result.length).toBe(4);
    });
  });

  describe('Ordering Tournaments', () => {
    it('should ordering tournaments by second world alphabetically, then entire string', () => {
      const result = orderTournaments([TOURNAMENTS.NA_RLCS, TOURNAMENTS.NA_RLRS, TOURNAMENTS.EU_RLCS, TOURNAMENTS.EU_RLRS]);
      expect(result).toEqual([TOURNAMENTS.EU_RLCS, TOURNAMENTS.NA_RLCS, TOURNAMENTS.EU_RLRS, TOURNAMENTS.NA_RLRS]);
    });
  });
});
