#!/bin/bash
dockerize -wait tcp://${RDS_HOSTNAME}:${RDS_PORT} -timeout 30s

if [ ! -f wp-config.php ]; then 
  wp core config \
  --dbhost=${RDS_HOSTNAME}:${RDS_PORT} \
  --dbuser=${RDS_USERNAME} \
  --dbpass=${RDS_PASSWORD} \
  --dbname=${RDS_DB_NAME} \
  --skip-check \
  --extra-php <<PHP
define( 'S3_UPLOADS_USE_INSTANCE_PROFILE', true );
define( 'S3_UPLOADS_BUCKET', '${S3_UPLOADS_BUCKET}' );
define( 'S3_UPLOADS_REGION', '${S3_UPLOADS_REGION}' );
PHP
fi

wp core install \
  --url=${WORDPRESS_URL:-localhost} \
  --title=${WORDPRESS_TITLE:-'WordPress site'} \
  --admin_user=${WORDPRESS_ADMIN_USER:-admin} \
  --admin_password=${WORDPRESS_ADMIN_PASSWORD:-admin} \
  --admin_email=${WORDPRESS_ADMIN_MAIL:-admin@example.com}

wp option update permalink_structure '/%postname%/'
wp plugin activate S3-Uploads
wp s3-uploads verify
wp plugin install rest-api --activate
wp plugin activate svg
wp server --host=0.0.0.0:8085
