import {CHANNEL, CHANNEL_ID} from '../common/constants';
import config from 'config'
import fetch from 'isomorphic-fetch';

export const REQUEST_LIVE = 'REQUEST_LIVE';
export const SET_LIVE = 'SET_LIVE';
export const SET_LAST_VIDEO = 'SET_LAST_VIDEO';

export function requestLive(){
  return {
    type: REQUEST_LIVE
  }
}

export function setLive() {
  return {
    type: SET_LIVE
  }
}

export function setLastVideo(videoId){
  return {
    type: SET_LAST_VIDEO,
    video: videoId
  }
}

function fetchWithHeaders(url){
  return fetch(new Request(url, {
    headers: new Headers({
      'Accept': 'application/vnd.twitchtv.v5+json',
      'Client-ID': config.twitch_client,
    })
  }));
}

export function fetchLastVideo() {
  let url = `https://api.twitch.tv/kraken/channels/${CHANNEL_ID}/videos`;
  return (dispatch) => {
    return fetchWithHeaders(url)
      .then(response => response.json())
      .then(data => {
        if(data == null || data.videos == null){
          throw new Error("Unable to find recent video");
        }else{
          dispatch(setLastVideo(data.videos[0]._id));
        }
      });
  }
}

export function fetchLive() {
  let url = `https://api.twitch.tv/kraken/streams/${CHANNEL_ID}`;
  return (dispatch) => {
    dispatch(requestLive())
    return fetchWithHeaders(url)
      .then(response => response.json())
      .then(data => {
        if(data.stream !== null)
          dispatch(setLive())
      });
  }
}

