import config from 'config';

export const RECEIVE_BRACKET = 'RECEIVE_BRACKET';
export const REQUEST_BRACKET = 'REQUEST_BRACKET';

export function requestBracket(){
  return {
    type: REQUEST_BRACKET
  }
}

export function receiveBracket(bracket) {
  return {
    type: RECEIVE_BRACKET,
    bracket
  }
}

export function fetchBracket() {
  return (dispatch) => {
    dispatch(requestBracket())

    return fetch(config.wp_api + 'pages?_embed')
      .then(response => response.json())
      .then(json => {
        let bracketMap = {
          playoffs: json.filter(obj => obj.slug === 'playoff-bracket')[0],
          finals: json.filter(obj => obj.slug === 'finals-bracket')[0]
        };
        dispatch(receiveBracket(bracketMap))
      });
  }
}
