import config from 'config';

export const RECEIVE_NEWS = 'RECEIVE_NEWS';
export const REQUEST_NEWS = 'REQUEST_NEWS';

export function requestNews(){
  return {
    type: REQUEST_NEWS
  }
}

export function receiveNews(news) {
  return {
    type: RECEIVE_NEWS,
    news
  }
}

export function fetchNews() {
  return (dispatch) => {
    dispatch(requestNews());

    return fetch(config.wp_api + 'posts?_embed&per_page=100')
      .then(response => response.json())
      .then(json => {
        dispatch(receiveNews(json));
      });
  }
}
