import config from 'config';

export const RECEIVE_TEAMS = 'RECEIVE_TEAMS';
export const RECEIVE_MATCHES = 'RECEIVE_MATCHES';

export function receiveTeams(teams) {
  return {
    type: RECEIVE_TEAMS,
    teams
  }
}

export function receiveMatches(matches) {
  return {
    type: RECEIVE_MATCHES,
    matches
  }
}

export function fetchMatches() {
  return (dispatch) => {
    return fetch(config.wp_api + 'matches?_embed&per_page=100')
      .then(response => response.json())
      .then(json => {
        dispatch(receiveMatches(json));
      });
  }
}

export function fetchTeams() {
  return (dispatch) => {
    return fetch(config.wp_api + 'teams?_embed&per_page=100')
      .then(response => response.json())
      .then(json => {
        dispatch(receiveTeams(json));
      });
  }
}
