import React from 'react';
import ReactDOM from 'react-dom';
import { Provider, connect } from 'react-redux';
import thunk from 'redux-thunk';
import { combineReducers, createStore, applyMiddleware, compose } from 'redux';

import fetch from 'isomorphic-fetch';
import * as reducers from './reducers.js';
import { fetchBracket, fetchLive, fetchLastVideo, fetchNews, fetchMatches, fetchTeams } from './actions.js';
import {backgroundImageUrl} from './common/helpers/image'

import Nav from './components/nav';
import Main from './components/main';
import News from './components/news';
import Watch from './components/watch';
import Footer from './components/footer';
import Info from './components/info';
import Teams from './components/teams';
import Brackets from './components/bracket';
import Format from './components/format';
import Register from './components/register';
import Matches from './components/matches';
import Standings from './components/standings';
// import Rules from './components/rules';

import * as style from './components/app/styles.scss'

const rootReducer = combineReducers(reducers);
const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;
const store = createStore(rootReducer, {
    app: {
      live: false,
      lastVideo: null
    },
    teams: {
      teams: {},
      matches: {},
    },
    bracket: {
      loading: true,
      content: {}
    }
  }, composeEnhancers(
    applyMiddleware(thunk),
  ));

let base = "/";
function mapStateToProps(state) {
  return state
}

class AsyncApp extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.currentTimeout = null;
  }

  componentWillMount() {
    this.props.dispatch(fetchBracket());
    this.props.dispatch(fetchTeams());
    this.props.dispatch(fetchMatches());
    this.props.dispatch(fetchLastVideo());
    this.props.dispatch(fetchLive());
    this.props.dispatch(fetchNews());
    this.currentTimeout = window.setTimeout(this.checkLive.bind(this), 30000);
  }

  componentWillUnmount() {
    window.clearTimeout(this.currentTimeout)
  }

  checkLive() {
    if(!this.props.app.live){
      this.props.dispatch(fetchLive());
      this.currentTimeout = window.setTimeout(this.checkLive.bind(this), 30000);
    }
  }

  render() {
    let sectionTeams = require('./components/teams/bg-teams.jpg');
    // var body = React.cloneElement(this.props.children, Object.assign({}, {
    //   bracket: this.props.bracket,
    // }))
    let watchSection = null;
    if(!this.props.app.live)
      watchSection = <Watch video={this.props.app.lastVideo}/>;

    return (
      <div className='root'>
        <Nav isLive={this.props.app.live}/>
        <Main isLive={this.props.app.live}/>
        <News />
        <Format />
        <Matches teams={this.props.teams.teams} matches={this.props.teams.matches}/>
        <Standings teams={this.props.teams.teams} bracket={this.props.bracket}/>
        {watchSection}
        <Footer />
        {this.props.children}
      </div>
    )
        // <Info />
        // <div className="section-container double" style={backgroundImageUrl(sectionTeams)}>
        //   <Teams />
        //   <Brackets bracket={this.props.bracket}/>
        // </div>
        // {watchSection}

  }
}

const App = connect(mapStateToProps)(AsyncApp);

class Root extends React.Component {
  render() {

    return (
      <Provider store={store}>
        <App></App>
      </Provider>
    );
  }
}
ReactDOM.render(<Root/>, document.getElementById('app'));
