const TWITCH_URL = 'https://www.twitch.tv/rocketleague';
const RULES_URL = '/rules';

export const SECTIONS = {
  NEWS: {
    title: 'news',
    icon: 'news.svg',
    enabled: true
  },
  MAIN: {
    title: 'main',
    icon: 'main_car.svg',
    enabled: true
  },
  FORMAT: {
    title: 'format',
    icon: 'schedule.svg',
    enabled: true
  },
  MATCHES: {
    title: 'matches',
    icon: 'matches.svg',
    enabled: true
  },
  STANDINGS: {
    title: 'standings',
    icon: 'standings.svg',
    enabled: true
  },
  RULES: {
    title: 'rules',
    icon: 'rules.svg',
    enabled: true,
    externalLink: RULES_URL
 },
 REGISTER: {
    title: 'register',
    icon: 'register.svg',
    enabled: true
 },
 WATCH: {
   title: 'watch',
   icon: 'matches.svg',
   enabled: true
 }
};

export const NORTH_AMERICA = {
  title: 'North America',
  key: 'NA',
};

export const EUROPE = {
  title: 'Europe',
  key: 'EU',
};

export const REGIONS = {
  NA: NORTH_AMERICA,
  EU: EUROPE,
};

export const ALL_REGIONS = [NORTH_AMERICA, EUROPE];

export const TWITCH_NAV_ITEM = {
  title: 'twitch',
  icon: 'glitch.svg',
  enabled: true,
  additionalClasses: ['twitch-nav-node'],
  externalLink: TWITCH_URL
};

export const CHANNEL = 'rocketleague';
export const CHANNEL_ID = 57781936;

// export const CHANNEL = 'nalcs1';
// export const CHANNEL_ID = 124420521;

export const SOCIAL_LINKS = {
  TWITTER: {
    icon: 'fa-twitter',
    url: 'https://twitter.com/rlcs',
    product: 'twitter'
  },
  FACEBOOK: {
    icon: 'fa-facebook',
    url: 'https://www.facebook.com/RLCS/',
    product: 'facebook'
  },
  TWITCH: {
    icon: 'fa-twitch',
    url: TWITCH_URL,
    product: 'twitch'
  },
  YOUTUBE: {
    icon: 'fa-youtube-play',
    url: 'https://www.youtube.com/channel/UCdKuPY64fEpI4cdlBSyvEJw',
    product: 'youtube'
  },
  REDDIT:{
    icon: 'fa-reddit',
    url: 'https://www.reddit.com/r/RocketLeague/',
    product: 'reddit'
  }
};
