
export const getParams = () => {
  let params;
  try{
    const search = location.search.replace('?', '');;
    params = search
      .split('&')
      .reduce((memo, param) => {
        const [key, value] = param.split('=');
        return {
          ...memo,
          [key]: value
        };
      }, {});
  }catch(err){
    console.log('issue parsing params');
    params = {};
  }
  return params;
}

// quick get url for articles
export const getUrl = () => {
  let path = location.pathname;
  // if home/root
  if (path === '/' || path === '') return null;

  path = path.slice(1);
  const split = path.split('/');
  let result = {
    section: split[0],
    slug: split[1]
  };
  return result;
}

export const replaceUrl = (path = '') => {
  window.history.replaceState(null, null, `${location.origin}${path}`)
}
