import React from 'react'
import {imageUrl, backgroundImageUrl} from '../common/helpers/image'
import * as style from './bracket/styles.scss'

export default class Brackets extends React.Component {
  render() {
    let titleText = require('./bracket/the_bracket.svg');
    let bracketImg = require('./bracket/outlined.svg');
    let brackets = <img className="brackets" src={imageUrl(bracketImg)} />;
    if(!this.props.bracket.loading){
      brackets = <img className="brackets" src={this.props.bracket.content.bg} />;
    }


    return (
      <section className="bracket-section">
       <div className="relative-content">
          <h2>Double Elimination</h2>
          <img className="titleText" src={imageUrl(titleText)} />

          <div className="brackets-container">
            {brackets}
          </div>
        </div>
      </section>
    );
  }
}
