import React from 'react';
import {SOCIAL_LINKS} from '../common/constants';
import * as style from './footer/styles.scss';

export default class Footer extends React.Component {
  render() {
    let rlcs = require('./footer/small_rlcs.png');
    let twitch = require('./footer/twitch.png');
    let psyonix = require('./footer/small_psyonix.png');

    let orderedSocial = [
      SOCIAL_LINKS.TWITTER,
      SOCIAL_LINKS.FACEBOOK,
      SOCIAL_LINKS.TWITCH,
      SOCIAL_LINKS.YOUTUBE
    ];

    let social = orderedSocial.map((obj, i) => {
      let classes = ['fa', obj.icon];
      return (
        <a href={obj.url} key={obj.product}>
          <i className={classes.join(' ')} aria-hidden="true"></i>
        </a>
      );
    });

    return (
      <footer className="footer">
        <div className="content">
          <img className="rlcs-logo" src={rlcs} />
          <img src={twitch} />
          <img src={psyonix} />
          
          <div className="social">
            {social}
          </div>
        </div>
      </footer>
    );
  }
}
