import React from 'react'
import {imageUrl, backgroundImageUrl} from '../common/helpers/image'
import * as style from './info/styles.scss'
import moment from 'moment-timezone'

const payoutStructure = [{
  place: 1,
  amount: '$50,000',
  color: 'gold'
},{
  place: 2,
  amount: '$25,000',
  color: 'silver'
},{
  place: 3,
  amount: '$15,000',
  color: 'bronze'
},{
  place: 4,
  amount: '$10,000'
},{
  place: 5,
  amount: '$7,500',
  numTeams: 2
},{
  place: 7,
  amount: '$5,000',
  numTeams: 2
}];

class SinglePrize extends React.Component{
  render() {
    let placeClasses = ["place"];
    let numTeams = null;
    if(this.props.numTeams && this.props.numTeams > 1)
      numTeams = (<div className="num-teams">{this.props.numTeams} Teams</div>)

    if(this.props.color)
      placeClasses.push(this.props.color)

    return (
      <li className="single-prize">
        <div className={placeClasses.join(' ')}>{this.props.place}</div>
        <div className="amount">{this.props.amount}</div>
        {numTeams}
      </li>
    );
  }
}

export default class Info extends React.Component {
  render() {
    let bgImage = require('./info/bg-venue.jpg');
    let titleText = require('./info/theater_amsterdam.svg');
    // let hotelBg = require('./info/hotel.png');
    let rulesIcon = require('./info/list.svg');
    let mapIcon = require('./info/location.svg');
    let rulesUrl = require('./info/rules.pdf');

    let prizes1 = payoutStructure.slice(0,3).map((place, i) => {
      return <SinglePrize {...place} key={place.place} />;
    });
    let prizes2 = payoutStructure.slice(3,6).map((place, i) => {
      return <SinglePrize {...place} key={place.place} />;
    });

    let getLocalTime = (timeStr, withTimezone = false) => {
      let format = 'hA';
      if(withTimezone)
        format += ' z';
      return moment(timeStr).tz(moment.tz.guess()).format(format);
    };

    let getEventTime = (timeStr) => {
      const TIMEZONE = "Europe/Amsterdam";
      return moment(timeStr).tz(TIMEZONE).format('h:mmA');
    };

    return (
      <section className="info-section section-container"
        style={backgroundImageUrl(bgImage)}>
        <div className="content">
          <h2>DECEMBER 3-4</h2>
          <img className="titleText" src={imageUrl(titleText)} />
          <h3>$125,000 Prize Pool</h3>
          <div className="info-container">
            <div className="prize-breakdown">
              <h4 className="prize-heading">Prize Breakdown</h4>
              <ul className="prizes-list">
                {prizes1}
              </ul>
              <ul className="prizes-list">
                {prizes2}
              </ul>
            </div>
            <div className="schedule-info">
              <h4 className="schedule-heading">
                General Schedule
              </h4>
              <div className="day-heading">
                <div className="bullet"></div>
                <h5>Saturday</h5>
              </div>
              <h6>{getEventTime('2016-11-12T11+01')} ({getLocalTime('2016-11-12T11+01', true)})</h6>
              <p>
                Doors Open
              </p>
              <h6>
                {getEventTime("2016-11-12T13+01")} - {getEventTime("2016-11-12T21+01")} ({getLocalTime("2016-11-12T13+01")} - {getLocalTime("2016-11-12T21+01", true)})
              </h6>
              <p>
                Upper Bracket Round 1, 2, and Lower Bracket Round 1
              </p>
              <h6>At Venue Only</h6>
              <p>
                Ultimate Fan Experience Meet & Greets with Top NA & EU Players! 
              </p>

              <div className="day-heading">
                <div className="bullet"></div>
                <h5>Sunday</h5>
              </div>
              <h6>{getEventTime("2016-11-13T12+01")} ({getLocalTime("2016-11-13T12+01", true)})</h6>
              <p>
                Doors Open
              </p>
              <h6>
                {getEventTime("2016-11-12T14+01")} - {getEventTime("2016-11-12T21+01")} ({getLocalTime("2016-11-12T14+01")} - {getLocalTime("2016-11-12T21+01", true)})
              </h6>
              <p>
                Lower Bracket Round 2, Semifinals, and Grand Finals
              </p>
              <h6>At Venue Only</h6>
              <p>
                Ultimate Fan Experience Meet & Greets with Top NA & EU Players! 
              </p>
              <h6>{getEventTime("2016-11-13T22+01")}+</h6>
              <p>
                RLCS AFTER PARTY! (Details to Be Announced)
              </p>
            </div>

            <div className="buttons-container">
              <a href={rulesUrl}>
                <button className="rules"><img src={imageUrl(rulesIcon)} /> View Rules</button>
              </a>
            </div>
          </div>
        </div>
      </section>
    );
  }
}
