import React from 'react'
import $ from 'jquery'
import {imageUrl, backgroundImageUrl} from '../common/helpers/image'
import {SOCIAL_LINKS, CHANNEL} from '../common/constants';
import * as style from './main/styles.scss'
import config from 'config'

const sponsors = ['psyonix.svg', 'twitch.svg', 'm1.svg', 'oldspice.svg', 'brisk_711.svg'];

class SponsorBar extends React.Component {
  render() {
    let sponsorItems = sponsors.map((sp, i) => {
      let imageSrc = require(`./main/sponsors/${sp}`);
      return (
        <div key={`sponsor_${i}`} className={["sponsor-container", sp.replace(/\.svg/, '')].join(' ')}
          style={backgroundImageUrl(imageSrc)}>
        </div>
      );
    });
    return (
      <section className="sponsor-bar">
        <div className="sponsor-content">
          {sponsorItems}
        </div>
      </section>
      );
  }
}

class MainLive extends React.Component {
  animateToBracket(){
    let destination = $('.bracket-section').offset().top;
    $('body, html').animate({scrollTop: destination}, 500);
  }

  render(){
    let src = `http://player.twitch.tv/?channel=${CHANNEL}`;
    let titleText = require('./main/finals_are_live.svg');

    let twitchIcon = require('./main/glitch.svg');
    let bracketIcon = require('./main/bracket.svg');

          /* title and button container
          <img className="title live" src={imageUrl(titleText)} />

          <div className="buttons-container">
            <a href={SOCIAL_LINKS.TWITCH.url} target="_blank">
              <button className="twitch-button"><img src={imageUrl(twitchIcon)}/>Watch On Twitch</button>
            </a>
            <button className="brackets-button" onClick={this.animateToBracket.bind(this)}><img src={imageUrl(bracketIcon)} />Bracket</button>
          </div>
        </div>
        */
    return (
      <div>
        <div className="content live">
          <div className="video-container">
            <div className="video-content">
              <iframe
                src={src}
                width="100%"
                height="100%"
                frameBorder="0"
                scrolling="no"
                allowFullScreen="true">
              </iframe>
            </div>
          </div>
        </div>
        <SponsorBar />
      </div>
    );
  }
}

class MainOffline extends React.Component {
  render(){
    let bgVideoMp4 = require('../common/assets/rlcs-finals.mp4');
    let bgVideoWebm = require('../common/assets/rlcs-finals.webm');
    let titleSvg = require('./main/s2_finals.svg');

    // <video preload autoPlay loop>
    //   <source src={bgVideoWebm} type="video/webm"/>
    //   <source src={bgVideoMp4} type="video/mp4"/>
    // </video>

    // <div className="content">
    //   <img className="logo" src={imageUrl(logo)} />
    //   <img className="title" src={imageUrl(titleSvg)} />
    // </div>
    return (
      <div>
        <div className="bg-container">
        </div>
        <SponsorBar />
      </div>
    );
  }
}

export default class Main extends React.Component {
  render() {
    const { isLive } = this.props;
    let bgImage = require('./main/bg.jpg');
    let content = <MainOffline />;
    let classes = ['main-section', 'section-container'];

    if (isLive) {
      bgImage = require('./main/live-watch.jpg');
      content = <MainLive />;
      classes.push('live');
    }

    return (
      <section className={classes.join(' ')}
        style={backgroundImageUrl(bgImage)}>
        {content}
      </section>
    );
  }
}
