import React from 'react'
import { connect } from 'react-redux';
import _ from 'lodash';
import {imageUrl, backgroundImageUrl} from '../common/helpers/image'
import { getUrl, replaceUrl } from '../common/helpers';
import * as style from './news/styles.scss'
import moment from 'moment-timezone'

const sampleArticle = {
  date: new Date(2017, 1, 10),
  title: 'THE NEWS HEADLINE GOES IN HERE',
  desc: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat.',
  cover: 'sample_cover.jpg',
  content: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp; Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp; Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp; Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at enim diam. Aenean rhoncus ornare lorem varius pulvinar. Proin nulla erat, luctus vitae lacus vitae, tristique fringilla arcu. Sed semper nisl quis arcu cursus auctor. Suspendisse condimentum auctor pharetra. Quisque rhoncus lectus non iaculis tincidunt. Fusce hendrerit magna commodo ex tincidunt placerat. &amp;&amp;&amp;&amp;'
};

const NUM_ARTICLES = 3;

class NewsComponent extends React.Component {
  constructor (props, context) {
    super(props, context);
    this.state = {
      pageNum: 1,
      articles: [],
      selected: null
    };
    const urlArgs = getUrl();
    this.getArticleAfterLoad = null;
    if ( urlArgs !== null && urlArgs.section === 'article' ) {
      this.getArticleAfterLoad = urlArgs.slug;
    }
  }

  componentWillUpdate(nextProps, nextState) {
    if(this.props.news.loading && !nextProps.news.loading){
      if(this.getArticleAfterLoad){
        this.findPageAndSelectArticle(this.getArticleAfterLoad, nextProps.news.content);
      }
    }
  }
  
  findPageAndSelectArticle(articleSlug, content) {
    if(!content){
      content = this.props.news.content || [];
    }
    const contentBySlug = _.keyBy(content, obj => obj.slug);
    const article = contentBySlug[articleSlug];
    const pageNum = Math.floor(content.indexOf(article) / NUM_ARTICLES) + 1;
    this.setState({
      pageNum,
      selected: article
    });
  }

  selectArticle(article) {
    replaceUrl(`/article/${article.slug}`);
    this.setState({
      selected: article
    });
  }

  setPage(pageNum) {
    this.setState({
      pageNum
    });
  }

  closeDetail(){
    replaceUrl('');
    this.setState({
      selected: null
    });
  }

  hasNextPage(){
    return this.props.news.content.length > (this.state.pageNum) * NUM_ARTICLES;
  }

  nextPage(){
    const articles = this.props.news.content;
    if (this.hasNextPage()) {
      this.setState({
        pageNum: this.state.pageNum + 1
      });
    }
  }

  hasPrevPage(){
    return this.state.pageNum !== 1;
  }

  prevPage(){
    const articles = this.props.news.content;
    if (this.hasPrevPage()){
      this.setState({
        pageNum: this.state.pageNum - 1
      });
    }
  }

  render(){
    const bgImage = require('./news/bg.jpg');
    const nextSVG = require(`../../static/next.svg`);
    const prevSVG = require(`../../static/previous.svg`);

    if (this.props.news.loading){
      return (
        <div className="news-section">
        </div>
      );
    }

    const start = (this.state.pageNum - 1) * NUM_ARTICLES;
    const allArticles = this.props.news.content;
    const articles = allArticles.slice(start, start + NUM_ARTICLES);

    let prevClasses= ['prev-button'];
    if ( !this.hasPrevPage() ){
      prevClasses.push('disabled');
    }

    let nextClasses = ['next-button'];
    if ( !this.hasNextPage() ){
      nextClasses.push('disabled');
    }

    return (
      <div className="news-section"
        style={backgroundImageUrl(bgImage)}>
        <NewsListings
          articles={articles}
          selected={this.state.selected}
          closeDetail={this.closeDetail.bind(this)}
          selectArticle={this.selectArticle.bind(this)} />
        <div className="controls">
          <div className={prevClasses.join(' ')}
            onClick={this.prevPage.bind(this)}>
            <img src={prevSVG} /> Prev
          </div>
          <div className="page-text">
            Page {this.state.pageNum}
          </div>
          <div className={nextClasses.join(' ')}
            onClick={this.nextPage.bind(this)}>
            Next <img src={nextSVG} />
          </div>
        </div>
      </div>
    );
  }
}

export default connect(state => state)(NewsComponent);

export class NewsListings extends React.Component {

  render(){
    const { articles, selectArticle, selected, closeDetail } = this.props;
    const content = articles.map((article, idx) => {
      const setArticle = () => {
        selectArticle(article);
      };
      return (
        <NewsDetail 
          key={article.id}
          idx={idx}
          article={article}
          selected={article === selected}
          closeDetail={closeDetail}
          setArticle={setArticle}/>
      );
    });
    
    return (
      <section className="news-listings">
        {content}
      </section>
    );
  }
}

export class NewsDetail extends React.Component {

  render(){
    const { article, closeDetail, selected, setArticle } = this.props;
    if (article == null) return null;
    const closeSVG = require(`../../static/close.svg`);
    const arrowSVG = require(`./news/arrow.svg`);
    const articleClasses = ['news-detail'];
    const articleProps = {};

    if( selected ) {
      articleClasses.push('selected');
    }else{
      articleProps.onClick = setArticle;
    }

    return(
      <div className={articleClasses.join(' ')} id={article.slug} {...articleProps}>
        <div className="heading">
          <div className="heading-bg" style={backgroundImageUrl(article.cover, true)} />
          <div className="heading-content">
            <div className="date">{moment(article.date).format('LL')}</div>
            <div className="title">{article.title}</div>
          </div>
          <div className="arrow-button">
            <img src={arrowSVG} />
          </div>
          <div className="close-button" onClick={closeDetail}>
            <img src={closeSVG} />
          </div>
        </div>
        <div className="description" dangerouslySetInnerHTML={{__html: article.content}}></div>
      </div>
    );
  }
}
