import React from 'react';
import _ from 'lodash';
import {imageUrl, backgroundImageUrl} from '../common/helpers/image';
import { ALL_REGIONS } from '../common/constants';
import * as style from './standings/styles.scss';

export default class ScheduleComponent extends React.Component {

  render() {
    const bg = require('./standings/standings_bg.jpg');
    const containerStyles = backgroundImageUrl(bg);
    const standings = this.renderStandings();
    const brackets = this.renderBrackets();

    return (
      <div className="section-container standings-section" style={containerStyles}>
        {standings}
        {brackets}
      </div>
    );
  }

  renderBrackets(){
    const { bracket } = this.props;
    if (bracket.loading) return null;

    const bracketTypes = ['playoffs', 'finals'];
    const bracketItems = bracketTypes
      .filter((type) => bracket.content[type])
      .map((type) => <img src={bracket.content[type]} className="single-bracket" />);
    
    return (
      <div className="brackets-container">
        {bracketItems}
      </div>
    );
  }

  renderStandings(){
    const { teams } = this.props;
    if(_.isEmpty(teams)) {
      return null
    }

    return ALL_REGIONS.map(region => {
      return (
        <div className="standing-container" key={region.key}>
          <div className="region-title">{region.title}</div>
          <div className="standing-contents">
            <div className="standing-header">
              <div className="standing">#</div>
              <div className="team-name">Teams</div>
              <div className="win-loss">W/L</div>
            </div>
            {this.renderStandingTable(region.key)}
          </div>
        </div>
      );
    });
  }

  renderStandingTable(region){
    const { teams } = this.props;
    const filtered = _.values(teams).filter(team => team.region === region);
    // stable sort promises 0-5 doesn't show before 0-0
    let standings = _.sortBy(filtered, (team) => -parseInt(team.weighting, 10));
    standings = _.sortBy(standings, (team) => team.losses);
    standings = _.sortBy(standings, (team) => -team.wins);

    return standings.map((team, idx) => {
      return (
        <div className="single-standing" key={team.id}>
          <div className="standing">{idx + 1}</div>
          <div className="team-name">{team.name}</div>
          <div className="win-loss">{team.wins} - {team.losses}</div>
        </div>
      );
    });
  }
}
