import React from 'react'
import {imageUrl, backgroundImageUrl} from '../common/helpers/image'
import * as style from './teams/styles.scss'

const teams = {
  NORTH_AMERICA: [{
    name: "Orbit Esports",
    players: ["Turtle", "Moses", "GarrettG"],
    logo: "orbit.png"
  },{
    name: "NRG",
    players: ["Fireburner", "Sadjunior", "Jacob"],
    logo: "nrg.png"
  },{
    name: "Genesis",
    players: ["Klassux", "Espeon", "Pluto"],
    logo: "genesis.png"
  },{
    name: "Take 3",
    players: ["Zanejackey", "Insolences", "Rizzo"],
    logo: "take3.png"
  }],
  EUROPE: [{
    name: "Northern Gaming",
    players: ["Remkoe", "Maestro", "Miztik"],
    logo: "northern.png"
  },{
    name: "Mockit Aces",
    players: ["Paschy90", "ViolentPanda", "Deevo"],
    logo: "mockit.png"
  },{
    name: "Flipsid3 Tactics",
    players: ["Markydooda", "Kuxir97", "gReazy"],
    logo: "flipside.png"
  },{
    name: "Precision Z",
    players: ["Sikii", "Kaydop", "Skyline"],
    logo: "precision.png"
  }]
};

class SingleTeam extends React.Component {
  render(){
    let players = this.props.players.reduce((memo, pl) => {
      return memo + ', ' + pl;
    });
    let imgSrc = require(`./teams/logos/${this.props.logo}`);

    return (
      <li className="single-team">
        <h4>{this.props.name}</h4>
        <p>{players}</p>
        <img src={imgSrc} />
      </li>
      );
  }
}

export default class Teams extends React.Component {
  render() {
    let titleText = require('./teams/competing_teams.svg');
    let NA = teams.NORTH_AMERICA.map((team, i) => {
      return <SingleTeam {...team} key={team.name} />;
    });
    let EU = teams.EUROPE.map((team, i) => {
      return <SingleTeam {...team} key={team.name} />;
    });

    return (
      <section className="teams-section">
       <div className="relative-content">
          <h2>8 Teams</h2>
          <img className="titleText" src={imageUrl(titleText)} />
          <div className="region-container">
            <h3>North America</h3>
            <ul className="teams">{NA}</ul>
          </div>
          <div className="region-container last">
            <h3>Europe</h3>
            <ul className="teams">{EU}</ul>
          </div>
        </div>
      </section>
    );
  }
}
