import React from 'react'
import {imageUrl, backgroundImageUrl} from '../common/helpers/image'
import {CHANNEL} from '../common/constants';

import * as style from './watch/styles.scss'

export default class Watch extends React.Component {
  render() {
    // let bgImage = require('./watch/bg-live.jpg');
    let bgImage = require('./watch/watch-bg.jpg');
    let titleText = require('./watch/watch_past_broadcast.svg');
    let src = `https://player.twitch.tv/?video=v99459626&!autoplay`;
    if(this.props.video){
      src = `https://player.twitch.tv/?video=${this.props.video}&!autoplay`;
    }

    return (
      <section className="watch-section section-container"
        style={backgroundImageUrl(bgImage)}>
        <div className="content">
          {/*<img className="titleText" src={imageUrl(titleText)} />*/}
          <div className="video-container">
            <div className="video-content">
              <iframe
                src={src}
                width="100%"
                height="100%"
                frameBorder="0"
                scrolling="no"
                allowFullScreen="true">
              </iframe>
            </div>
          </div>
        </div>
      </section>
    );
  }
}
