import { reduce } from 'lodash';
import * as actions from '../actions/bracket';

// bracketMap = {playoff: {}, finals: {}}
function transformBracket(bracketMap) {
  // var featuredMedia = bracket._embedded['wp:featuredmedia'] ? bracket._embedded['wp:featuredmedia'][0].source_url : ''
  return reduce(bracketMap, (result, value, key) => {
    let ret = undefined;
    if (value !== undefined) {
      ret = value._embedded['wp:featuredmedia'] ? value._embedded['wp:featuredmedia'][0].source_url : undefined;
    }
    return { ...result, [key]: ret};
  }, {});
}

function receiveBracket(state, action){
  return {
    ...state,
    loading: false,
    content: transformBracket(action.bracket)
  }
}

export function bracket(state = {}, action) {
  switch(action.type) {
    case actions.RECEIVE_BRACKET:
      return receiveBracket(state, action)
    case actions.REQUEST_BRACKET:
      return {
        ...state,
        loading: true
      }
    default:
      return state
  }
}
