import * as actions from '../actions/news';

function transformNews(article) {
  const coverImage = article._embedded['wp:featuredmedia'] ? article._embedded['wp:featuredmedia'][0].source_url : '';
  const title = article.title.rendered;
  const content = article.content.rendered;
  const desc = article.excerpt.rendered;
  const date = new Date(article.date);
  const slug = article.slug;
  const id = article.id;

  return {
    id,
    date,
    cover: coverImage,
    title,
    content,
    desc,
    slug
  };
}

function receiveNews(state, action){
  return {
    ...state,
    loading: false,
    content: action.news.map((n) => transformNews(n))
  }
}

export function news(state = {}, action) {
  switch(action.type) {
    case actions.RECEIVE_NEWS:
      return receiveNews(state, action)
    case actions.REQUEST_NEWS:
      return {
        ...state,
        loading: true
      }
    default:
      return state
  }
}
