import * as actions from '../actions/teams';

function transformMatches(matches) {
  let trimmedDown = matches.map((match) => {
    return {
      id: match.id,
      title: match.title.rendered,
      week: match.fields.week,
      team_one: {
        id: match.fields.team_one,
        score: match.fields.team_one_score,
      },
      team_two: {
        id: match.fields.team_two,
        score: match.fields.team_two_score,
      },
      date_time: match.fields.date_time,
      region: match.fields.region,
      status: match.fields.status,
    };
  });

  // create id mapping
  return trimmedDown.reduce((memo, match) => {
    return {
      ...memo,
      [match.id]: match,
    };
  }, {});
}

function receiveMatches(state, action){
  return {
    ...state,
    matches: transformMatches(action.matches)
  }
}

function transformTeams(teams){
  let trimmedDown = teams.map((team) => {
    return {
      id: team.id,
      name: team.title.rendered,
      abbr: team.fields.abbreviation,
      region: team.fields.region,
      wins: team.fields.wins,
      losses: team.fields.losses,
      weighting: team.fields.weighting || 0,
    };
  });

  return trimmedDown.reduce((memo, team) => {
    return {
      ...memo,
      [team.id]: team,
    };
  }, {});
}

function receiveTeams(state, action){
  return {
    ...state,
    teams: transformTeams(action.teams)
  }
}

export function teams(state = {}, action) {
  switch(action.type) {
    case actions.RECEIVE_MATCHES:
      return receiveMatches(state, action);
    case actions.RECEIVE_TEAMS:
      return receiveTeams(state, action);
    default:
      return state;
  }
}
